// these follow the manifest format
var vendors  = { }
var products = [ ]

// info = {
//    type             = "AirPlay" | "Local" | "Meridian" | "Squeezebox" | "Sonos" | "Devialet" | "Kef" | "SongcastDirect" | "Cast"
//    vendor           = "foo" | undefined,
//    model            = "foo" | undefined,
//    descname         = "foo" | undefined,
//    usb_id           = "1234:abcd" | undefined,
//    asio_driver_id   = "{12123123123123112-12-3-123-13-12}" | undefined,
//}
function auto_detect(info_str) {
    var info = JSON.parse(info_str);
    
    var model          = info.model            || "";
    var vendor         = info.vendor           || "";
    var descname       = info.descriptive_name || "";

    var lowervendor    = vendor.toLowerCase();
    var lowermodel     = model.toLowerCase();
    var lowerdescname  = descname.toLowerCase();
  
    var result = {
        exact_device: null,
        candidate_devices:[ ],
    };

    function exact_match(device) {
        if (result.exact_device) return;
        result.exact_device      = device.id;
        result.candidate_devices = [ device.id ];
    }

    function find_device_by_name(vendor_name, model_name) {
        for (var idx in products) {
            var device = products[idx];
            if ((device.vendor.name   == vendor_name || device.vendor.friendly_name == vendor_name) &&
                (device.name          == model_name  || device.friendly_name        == model_name)) {
                return device;
            }
        }
    }

    function exact_match_by_name(vendorname, modelname) {
        device = find_device_by_name(vendorname, modelname);
        if (device) exact_match(device);
        else console.log("warning: exact match device not found vendor='" + vendorname + "' model='" + modelname +"'");
    }

    function candidate_match(device) {
        if (result.exact_device) return;
        if (!result.candidate_devices.includes(device.id)) result.candidate_devices.push(device.id);
    }

    if (info.type == "Local") {
        var usb_vendor, usb_product;

        if (info.usb_id) {
            var splits = info.usb_id.split(":");
            usb_vendor  = splits[0];
            usb_product = splits[1];

            for (var idx in products) {
                var device = products[idx];
                if (device.usb && device.usb.usb_id && device.usb.usb_id_is_unique && device.usb.usb_id.includes(info.usb_id)) {
                    exact_match(device);
                }
            }
        }

        if (usb_vendor == "2522") {         // LH Labs
            if (usb_product == "0018") {
                if (lowermodel.includes("infinit"))          exact_match_by_name("LH Labs", "Geek Out V2 Infinity");
                else                                         exact_match_by_name("LH Labs", "Geek Out V2");
            }
            if (usb_product == "001a") {
                if (lowermodel.includes("infinit"))          exact_match_by_name("LH Labs", "Geek Out V2+ Infinity");
                else                                         exact_match_by_name("LH Labs", "Geek Out V2+");
            }
            if (usb_product == "0012") {
                if (lowermodel.includes("infinit"))          exact_match_by_name("LH Labs", "Vi DAC Infinity");
                else                                         exact_match_by_name("LH Labs", "Vi DAC");
            }
            if (usb_product == "0009") {
                if (lowermodel.includes("pulse x∞"))         exact_match_by_name("LH Labs", "Pulse X Infinity");
                if (lowermodel.includes("pulse x infinit"))  exact_match_by_name("LH Labs", "Pulse X Infinity");
                if (lowermodel.includes("pulse x"))          exact_match_by_name("LH Labs", "Pulse X");
                else                                         exact_match_by_name("LH Labs", "Pulse");
            }
        }

        if (vendor == "Chord Electronics Ltd" || descname.startsWith("Chord Electronics Ltd")) {
			if (model == "Hugo2"  || descname == "Chord Electronics Ltd Hugo2")  exact_match_by_name("Chord", "Hugo 2");
			if (model == "Dave"   || descname == "Chord Electronics Ltd Dave")   exact_match_by_name("Chord", "Dave");
			if (model == "Hugo"   || descname == "Chord Electronics Ltd Hugo")   exact_match_by_name("Chord", "Hugo");
            if (model == "HugoTT" || descname == "Chord Electronics Ltd HugoTT") exact_match_by_name("Chord", "Hugo TT");
            if (model == "HugoTT2" || descname == "Chord Electronics Ltd HugoTT2") exact_match_by_name("Chord", "Hugo TT 2");
            if (model == "Hugo M SCALER" || descname == "Chord Electronics Ltd Hugo M SCALER") exact_match_by_name("Chord", "Hugo M Scaler");
			if (model == "Mojo"   || descname == "Chord Electronics Ltd Mojo")   exact_match_by_name("Chord", "Mojo");
            if (model == "Mojo2"   || descname == "Chord Electronics Ltd Mojo2")   exact_match_by_name("Chord", "Mojo 2");
			if (model == "Blu2"   || descname == "Chord Electronics Ltd Blu2")   exact_match_by_name("Chord", "Blu Mk. 2");
        }
        

        if (lowermodel.includes("snd_allo_digione") || lowervendor.includes("snd_allo_digione")) exact_match_by_name("Allo", "DigiOne");
        if (lowermodel.includes("bossdac")          || lowervendor.includes("bossdac"))          exact_match_by_name("Allo", "Boss DAC");
        if (lowermodel.includes("pianodacplus")     || lowervendor.includes("pianodacplus"))     exact_match_by_name("Allo", "Piano 2.1");
        if (lowermodel.includes("pianodac")         || lowervendor.includes("pianodac"))         exact_match_by_name("Allo", "Piano");

        if (lowermodel.includes("hifiberry") || lowervendor.includes("hifiberry")) {
            if (lowermodel.includes("dac+"))  exact_match_by_name("HifiBerry", "DAC+");
            if (lowermodel.includes("amp+"))  exact_match_by_name("HifiBerry", "Amp+");
            if (lowermodel.includes("digi+")) exact_match_by_name("HifiBerry", "Digi+");
        }
        if (lowermodel.includes("iqaudio") || lowervendor.includes("iqaudio")) {
            if (lowermodel.includes("iqaudiodac")) {
                exact_match_by_name("IQaudIO", "Pi-DAC+");
            }
        }
        if (lowermodel.startsWith("meridian") || lowervendor.startsWith("meridian")) {
            if (model.includes("Explorer²"))  exact_match_by_name("Meridian", "Explorer2");
            if (model.includes("Explorer"))   exact_match_by_name("Meridian", "Explorer");
            if (model.includes("ID28"))       exact_match_by_name("Meridian", "ID28");
            if (model.includes("ID29"))       exact_match_by_name("Meridian", "ID29");
            if (model.includes("800 Series")) exact_match_by_name("Meridian", "800 Series");
            if (model.includes("Prime"))      exact_match_by_name("Meridian", "Prime");
            if (model.includes("Director"))   exact_match_by_name("Meridian", "Director");

            if (descname.includes("Explorer²"))  exact_match_by_name("Meridian","Explorer2");
            if (descname.includes("Explorer"))   exact_match_by_name("Meridian","Explorer");
            if (descname.includes("ID28"))       exact_match_by_name("Meridian","ID28");
            if (descname.includes("800 Series")) exact_match_by_name("Meridian","800 Series");
            if (descname.includes("ID29"))       exact_match_by_name("Meridian","ID29");
            if (descname.includes("Prime"))      exact_match_by_name("Meridian","Prime");
            if (descname.includes("Director"))   exact_match_by_name("Meridian","Director");
        }
        if (lowermodel.includes("mytek") || lowervendor.includes("mytek")) {
            if (model.includes("Stereo 192-dsd DAC"))    exact_match_by_name("Mytek", "Stereo192-DSD DAC");
            if (model.includes("Manhattan"))             exact_match_by_name("Mytek", "The Manhattan");
            if (descname.includes("Stereo 192-dsd DAC")) exact_match_by_name("Mytek", "Stereo192-DSD DAC");
            if (descname.includes("Manhattan"))          exact_match_by_name("Mytek", "The Manhattan");
        }
        if (lowermodel.includes("audioquest") || lowervendor.includes("audioquest")) {
            if (lowermodel.includes("dragonfly red"))   exact_match_by_name("AudioQuest", "DragonFly Red");
            if (lowermodel.includes("dragonfly black")) exact_match_by_name("AudioQuest", "DragonFly Black");
            if (lowermodel.includes("dragonfly cobalt")) exact_match_by_name("AudioQuest", "DragonFly Cobalt");
            if (lowermodel.includes("dragonfly"))       exact_match_by_name("AudioQuest", "DragonFly");
        }
        if (lowermodel.includes("didit") || lowervendor.includes("didit")) {
            if (lowermodel.includes("DAC212")) exact_match_by_name("DiDiT", "DAC212");
        }
        if (lowermodel.includes("exasound") || lowerdescname.includes("exasound") || lowervendor.includes("exasound")) {
            if (lowerdescname.includes("e12") || lowermodel.includes("e12")) exact_match_by_name("exaSound", "e12");
            if (lowerdescname.includes("e18") || lowermodel.includes("e18")) exact_match_by_name("exaSound", "e18");
            if (lowerdescname.includes("e20") || lowermodel.includes("e20")) exact_match_by_name("exaSound", "e20");
            if (lowerdescname.includes("e22") || lowermodel.includes("e22")) exact_match_by_name("exaSound", "e22");
            if (lowerdescname.includes("e28") || lowermodel.includes("e28")) exact_match_by_name("exaSound", "e28");
            if (lowerdescname.includes("e32") || lowermodel.includes("e32")) exact_match_by_name("exaSound", "e32");
            if (lowerdescname.includes("e38") || lowermodel.includes("e38")) exact_match_by_name("exaSound", "e38");
            if (lowerdescname.includes("e48") || lowermodel.includes("e48")) exact_match_by_name("exaSound", "e48");
            if (lowerdescname.includes("e62") || lowermodel.includes("e62")) exact_match_by_name("exaSound", "e62");
            if (lowerdescname.includes("e68") || lowermodel.includes("e68")) exact_match_by_name("exaSound", "e68");
          	if (lowerdescname.includes("e82") || lowermodel.includes("e82")) exact_match_by_name("exaSound", "e82");
          	if (lowerdescname.includes("e88") || lowermodel.includes("e88")) exact_match_by_name("exaSound", "e88");
        }
        if (vendor == "Merging Technologies S.A.") {
            if (model == "MERGING+NADAC") exact_match_by_name("Merging Technologies", "NADAC");
        }
        
        if (vendor == "Apple") {
            if (model == "iPhone10,6" || model == "iPhone10,3") exact_match_by_name("Apple", "iPhone X");
            if (model.startsWith("iPhone"))                     exact_match_by_name("Apple", "iPhone");
            if (model.startsWith("iPad"))                       exact_match_by_name("Apple", "iPad");
        }
      
        // if we haven't got an exact by now, try to do candidate matches
        // based on USB id or ASIO driver id
        for (var idx in products) {
          var device = products[idx];
          if (device.usb && device.usb.usb_id) {
            if (!device.usb.usb_id_is_unique && info.usb_id && device.usb.usb_id.includes(info.usb_id)) {
              candidate_match(device);
            }
            if (device.usb.asio_driver_id_32bit && info.asio_driver_id == device.usb.asio_driver_id_32bit) {
              candidate_match(device);
            }
            if (device.usb.asio_driver_id_64bit && info.asio_driver_id == device.usb.asio_driver_id_64bit) {
              candidate_match(device);
            }
          }
        }

    } else if (info.type == "Squeezebox") {
        for (var idx in products) {
            var device = products[idx];
            if (device.squeezebox && device.squeezebox.model == info.model) {
                exact_match(device);
            }
        }

    } else if (info.type == "Kef") {
        if (info.model == "LSX") {
            exact_match_by_name("KEF", "LSX");
        } else {
            exact_match_by_name("KEF", "LS50 Wireless");
        }
    } else if (info.type == "SongcastDirect") {
        for (var idx in products) {
            var device = products[idx];
            var mungemodel = info.model.replace("Renew ","");
            if (device.songcast_direct && device.songcast_direct.vendor == info.vendor && device.songcast_direct.model == mungemodel) {
                exact_match(device);
            }
        }

    } else if (info.type == "Cast") {
      	if (info.model == "Chromecast") {
            exact_match_by_name("Google", "Chromecast");
            for (var idx in products) {
                var device = products[idx];
                if (device.cast && device.cast.model == "Chromecast") {
                    result.candidate_devices.push(device.id);
                }
            }
        } else {
          for (var idx in products) {
              var device = products[idx];
              if (device.cast && device.cast.vendor == info.vendor && device.cast.model  == info.model) {
                  exact_match(device);
              }
          }
        }

    } else if (info.type == "AirPlay") {
        if (!info.vendor) {
            if (lowermodel.startsWith("a7_")      || lowerdescname.startsWith("a7_"))     exact_match_by_name("B&W", "A7");
            if (lowermodel.startsWith("a5_")      || lowerdescname.startsWith("a5_"))     exact_match_by_name("B&W", "A5");
            if (lowermodel.startsWith("z2_")      || lowerdescname.startsWith("z2_"))     exact_match_by_name("B&W", "Z2"); 
            if (lowermodel.startsWith("t7_")      || lowerdescname.startsWith("t7_"))     exact_match_by_name("B&W", "T7");
            if (lowermodel.startsWith("appletv")  || lowerdescname.startsWith("appletv")) exact_match_by_name("Apple", "Apple TV");
            if (lowermodel.startsWith("airport4") || lowerdescname.startsWith("airport4")) exact_match_by_name("apple", "airport express");
            if (lowermodel.startsWith("audioaccessory6,1|audioaccessory6,1"))              exact_match_by_name("Apple", "HomePod (Stereo Pair)");
            if (lowermodel.startsWith("audioaccessory6,1|appletv"))                        exact_match_by_name("Apple", "Apple TV / HomePod");
            if (lowermodel.startsWith("audioaccessory6,1"))                                exact_match_by_name("Apple", "HomePod");
            if (lowermodel.startsWith("audioaccessory5,1|audioaccessory5,1"))              exact_match_by_name("Apple", "HomePod mini (Stereo Pair)");
            if (lowermodel.startsWith("audioaccessory5,1|appletv"))                        exact_match_by_name("Apple", "Apple TV / HomePod mini");  
            if (lowermodel.startsWith("audioaccessory5,1"))                                exact_match_by_name("Apple", "HomePod mini");  
            if (lowerdescname.startsWith("denon")){
                var tempVendor = "Denon";
                var tempDevice = model;
                exact_match_by_name(tempVendor, tempDevice)
            }
            if (lowerdescname.startsWith("marantz")){
                var tempVendor = "Marantz";
                var tempDevice = model;
                exact_match_by_name(tempVendor, tempDevice)
            }
            if (lowermodel.startsWith("str-a") || lowermodel.startsWith("ta-an")) {
                var tempVendor = "Sony";
                var tempDevice = model;
                exact_match_by_name(tempVendor, tempDevice)
            }
          
            if (lowermodel == "rossini player") exact_match_by_name("dCS", "Rossini Player");
            if (lowermodel == "rossini dac")    exact_match_by_name("dCS", "Rossini DAC");
            if (lowermodel == "shairportsync") {
                if (lowerdescname.includes("discovery z3")) exact_match_by_name("ELAC", "Discovery Z3");
            }


            var linnmungename = lowerdescname.replace("renew ", "");
	   	    if (linnmungename.includes("klimax dsm"))        exact_match_by_name("Linn", "Klimax DSM");
		    if (linnmungename.includes("klimax exakt dsm"))  exact_match_by_name("Linn", "Klimax Exakt DSM");
            if (linnmungename.includes("klimax ds"))         exact_match_by_name("Linn", "Klimax DS");
		    if (linnmungename.includes("akurate dsm"))       exact_match_by_name("Linn", "Akurate DSM");
		    if (linnmungename.includes("akurate exakt dsm")) exact_match_by_name("Linn", "Akurate Exakt DSM");
		    if (linnmungename.includes("akurate ds"))        exact_match_by_name("Linn", "Akurate DS");
		    if (linnmungename.includes("majik dsm"))         exact_match_by_name("Linn", "Majik DSM");
		    if (linnmungename.includes("majik ds-i"))        exact_match_by_name("Linn", "Majik DS-I");
  		    if (linnmungename.includes("majik ds"))          exact_match_by_name("Linn", "Majik DS");
		    if (linnmungename.includes("sekrit ds-i"))       exact_match_by_name("Linn", "Sekrit DS-I");
		    if (linnmungename.includes("sekrit dsm"))        exact_match_by_name("Linn", "Sekrit DSM");
 		    if (linnmungename.includes("sekrit ds"))         exact_match_by_name("Linn", "Sekrit DS");
		    if (linnmungename.includes("kiko dsm"))          exact_match_by_name("Linn",  "Kiko DSM");
		    if (linnmungename.includes("sneaky music ds"))   exact_match_by_name("Linn", "Sneaky Music DS");
		    if (linnmungename.includes("sneaky dsm"))        exact_match_by_name("Linn", "Sneaky DSM");
            
            if (model == "Devialet Expert") {
                exact_match_by_name("Devialet SA", "Expert");
                for (var idx in products) {
                    var device = products[idx];
                    if (device.vendor.name == "Devialet SA") {
                        if (device.name.includes("Expert") || device.name.includes("Original d'Atelier") || device.name.includes("D-Premier")) {
                            result.candidate_devices.push(device.id);
                        }
                    }
                }
            }
        }

        for (var idx in products) {
            var device = products[idx];
            if (device.airplay && device.airplay.model == info.model) {
                exact_match(device);
            }
        }

    } else if (info.type == "Sonos") {
        for (var idx in products) {
            var device = products[idx];
            if (device.sonos && device.sonos.model == info.model) {
                exact_match(device);
            }
        }
    } else if (info.type == "HQPlayer") {
        exact_match_by_name("Signalyst", "HQPlayer");
      
    } else if (info.type == "Devialet") {
        exact_match_by_name("Devialet", "Expert");
        for (var idx in products) {
            var device = products[idx];
            if (device.vendor.name == "Devialet SA") {
                if (device.name.includes("Expert") || device.name.includes("Original d'Atelier") || device.name.includes("D-Premier")) {
   					result.candidate_devices.push(device.id);
                }
            }
        }

    } else if (info.type == "Meridian") {
        for (var idx in products) {
            var device = products[idx];
            if (device.meridian && device.meridian.model == info.model) {
                exact_match(device);
            }
        }

    } else if (info.type == "RoonReady") {
        for (var idx in products) {
            var device = products[idx];
            if (device.raat && device.raat.vendor == info.vendor && device.raat.model == info.model) {
                exact_match(device);
            }
        }
    } else if (info.type == "Headphones") {
        for (var idx in products) {
            var device = products[idx];
            var tmpmodel = info.model;
            if (tmpmodel == "iSINE10/LX") tmpmodel = "iSINE10";
            if (device.vendor.name == info.vendor && device.name == tmpmodel) {
                exact_match(device);
            }
        }
    }
    return JSON.stringify(result);
}

// Initialize the autodetect script
// 
// The argument is the manifest_1.json from the same package, passed as a string. 
//
// You can see the format by hitting https://devicedb.roonlabs.net/1/manifest.
//
// Note that while loading the manifest, we follow the vendor_id links in the product objects,
// so you can do product.vendor.id, product.vendor.name, etc in the code above.
//
function init(manifest_str) {
    var manifest = JSON.parse(manifest_str);
    
    for (var i in manifest.vendors) {
        var v = manifest.vendors[i];
        vendors[v.id] = v;
    }
    for (var i in manifest.products) {
        var p = manifest.products[i];
        p.vendor = vendors[p.vendor_id];
        products.push(p);
    }
}

if (!String.prototype.includes) {
  String.prototype.includes = function(search, start) {
    'use strict';
    if (typeof start !== 'number') {
      start = 0;
    }
    
    if (start + search.length > this.length) {
      return false;
    } else {
      return this.indexOf(search, start) !== -1;
    }
  };
}

if (!String.prototype.startsWith) {
    String.prototype.startsWith = function(search, pos) {
        return this.substr(!pos || pos < 0 ? 0 : +pos, search.length) === search;
    };
}

// https://tc39.github.io/ecma262/#sec-array.prototype.includes
if (!Array.prototype.includes) {
  Object.defineProperty(Array.prototype, 'includes', {
    value: function(searchElement, fromIndex) {

      if (this == null) {
        throw new TypeError('"this" is null or not defined');
      }

      // 1. Let O be ? ToObject(this value).
      var o = Object(this);

      // 2. Let len be ? ToLength(? Get(O, "length")).
      var len = o.length >>> 0;

      // 3. If len is 0, return false.
      if (len === 0) {
        return false;
      }

      // 4. Let n be ? ToInteger(fromIndex).
      //    (If fromIndex is undefined, this step produces the value 0.)
      var n = fromIndex | 0;

      // 5. If n ≥ 0, then
      //  a. Let k be n.
      // 6. Else n < 0,
      //  a. Let k be len + n.
      //  b. If k < 0, let k be 0.
      var k = Math.max(n >= 0 ? n : len - Math.abs(n), 0);

      function sameValueZero(x, y) {
        return x === y || (typeof x === 'number' && typeof y === 'number' && isNaN(x) && isNaN(y));
      }

      // 7. Repeat, while k < len
      while (k < len) {
        // a. Let elementK be the result of ? Get(O, ! ToString(k)).
        // b. If SameValueZero(searchElement, elementK) is true, return true.
        if (sameValueZero(o[k], searchElement)) {
          return true;
        }
        // c. Increase k by 1. 
        k++;
      }

      // 8. Return false
      return false;
    }
  });
}
